<?php
App::uses('AppController', 'Controller');

class InstallController extends AppController
{
    public $components = array('Session');
    public $helpers = array('Html', 'Form');

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->layout = 'install';
        $this->Auth->allow();
        $this->Security->unlockedActions = array('index', 'database', 'data', 'adminuser', 'finish');
    }

    /**
     * If settings.json exists, app is already installed
     *
     * @return void
     */
    protected function _check()
    {
        if (Configure::read('App.installed')) {
            //$this->Session->setFlash( 'Already Installed' );
            return $this->redirect('/');
        }
    }

    /**
     * Step 0: welcome
     *
     * A simple welcome message for the installer.
     *
     * @return void
     * @access public
     */
    public function index()
    {
        $this->_check();
        $this->set('title_for_layout', __('Installation: Welcome'));
    }

    /**
     * Step 1: database
     *
     * Try to connect to the database and give a message if that's not possible so the user can check their
     * credentials or create the missing database
     * Create the database file and insert the submitted details
     *
     * @return void
     * @access public
     */
    public function database()
    {
        $this->_check();
        $this->set('title_for_layout', __('Step 1: Database'));

        if (Configure::read('App.installed')) {
            return $this->redirect(array('action' => 'adminuser'));
        }

        if (!empty($this->request->data)) {
            $this->request->data['Install']['datasource'] = 'Database/Mysql';
            $this->request->data['Install']['prefix'] = '';
            $this->request->data['Install']['port'] = '3306';

            try {
                App::uses('ConnectionManager', 'Model');
                $config = array(
                    'datasource' => $this->request->data['Install']['datasource'],
                    'persistent' => false,
                    'host' => $this->request->data['Install']['host'],
                    'login' => $this->request->data['Install']['login'],
                    'password' => $this->request->data['Install']['password'],
                    'database' => $this->request->data['Install']['database'],
                    'port' => $this->request->data['Install']['port'],
                    'prefix' => $this->request->data['Install']['prefix'],
                    'encoding' => 'utf8',
                );
                @ConnectionManager::create('default', $config);
            } catch (Exception $connectionError) {
                $currentConfiguration = array(
                    'exists' => false,
                    'valid' => false,
                );
                $this->set('currentConfiguration', $currentConfiguration);
                return $this->Session->setFlash('Cant connect to database. Please check the fields below.');
            }

            $result = $this->Install->createDatabaseFile($this->request->data);
            if ($result !== true) {
                $this->Session->setFlash($result);
            } else {
                return $this->redirect(array('action' => 'data'));
            }
        }

        $currentConfiguration = array(
            'exists' => false,
            'valid' => false,
        );
        if (file_exists(APP . 'Config' . DS . 'database.php')) {
            $currentConfiguration['exists'] = true;
        }
        if ($currentConfiguration['exists']) {
            App::uses('ConnectionManager', 'Model');
            try {
                $connected = ConnectionManager::getDataSource('default');
            } catch (Exception $connectionError) {
                $connected = false;
            }

            if ($connected && $connected->isConnected()) {
                $currentConfiguration['valid'] = true;
            }
        }
        $this->set('currentConfiguration', $currentConfiguration);
    }

    /**
     * Step 2: Run the initial sql scripts to create the db and seed it with data
     *
     * @return void
     * @access public
     */
    public function data()
    {
        $this->_check();
        $this->set('title_for_layout', __d('croogo', 'Step 2: Build database'));

        $this->loadModel('Install');
        $db = $this->Install->getDataSource();
        $db->cacheSources = false;

        $sources = $db->listSources();

        if (!empty($sources)) {
            $this->Session->setFlash(
                __('Warning: Database "%s" is not empty.', $db->config['database']),
                'default',
                array('class' => 'error')
            );
        }

        if ($this->request->query('run')) {
            set_time_limit(10 * MINUTE);

            try {
                $result = $this->Install->runMigrations();
            } catch (Exception $ex) {
                $result = $ex->getMessage();
            }

            if ($result !== true) {
                return $this->Session->setFlash($result);
            }

            return $this->redirect(array('action' => 'adminuser'));
        }
    }

    /**
     * Step 3: get username and passwords for administrative user
     */
    public function adminuser()
    {
        $this->set('title_for_layout', __('Step 3: Create Admin User'));

        if (!file_exists(APP . 'Config' . DS . 'database.php')) {
            return $this->redirect('/');
        }

        if ($this->request->is('post')) {
            $this->loadModel('User');
            $this->User->set($this->request->data);
            if ($this->User->validates()) {
                $user = $this->Install->addAdminUser($this->request->data);
                if ($user) {
                    return $this->redirect(array('action' => 'finish'));
                }
            }
        }
    }

    /**
     * Step 4: finish
     *
     * @return void
     * @access public
     */
    public function finish()
    {
        $this->set('title_for_layout', __('Installation successful'));
        $this->_check();

        App::uses('ClassRegistry', 'Utility');
        $option = ClassRegistry::init('Option');

        $option->updateAll(array('Option.option_value' => "'1'"), array('Option.option_name' => 'installed'));

        $this->Session->destroy();
    }
}
